IF  EXISTS (SELECT * FROM sys.objects 
				WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO]
GO 
--EXEC P_EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO 900,2015,7
CREATE PROCEDURE P_EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO  (@CD_FILIAL INT, @ANO INT=0,@MES INT=0, @DT_BASE DATETIME=NULL)
AS
 
DECLARE @DT_REF DATETIME;
DECLARE @DT_INI DATETIME;
DECLARE @DT_FIM DATETIME;

IF @ANO >0 AND @MES>0
BEGIN
	SET @DT_INI=CONVERT(VARCHAR,@ANO*100+@MES) +'01';
	SET @DT_FIM=dbo.F_FINAL_MES(@DT_INI)
END
ELSE
BEGIN
	SET @DT_BASE=GETDATE();
END

IF NOT @DT_BASE IS NULL
BEGIN 
	SET @DT_INI =@DT_BASE 
	SET @DT_FIM =@DT_BASE 
	SET @ANO=YEAR(@DT_BASE)
	SET @MES=MONTH(@DT_BASE)
END
SET @DT_REF =@DT_INI; 

/******************************************************************************************************/

	Print 'Atualiza os custos nas nf saida'
	EXEC P_EST_NF_SAI_IT_REPROCESSAR_CUSTO @MES,@ANO,@CD_FILIAL,0,@DT_BASE;

/******************************************************************************************************/
/******************************************************************************************************/

	BEGIN TRY 
	DROP TABLE RsProdAjusteMov   
	END TRY BEGIN CATCH END CATCH;

	CREATE TABLE RsProdAjusteMov  (CD_EMP		INT, 
								CD_FIL_ORIG	INT,
								CD_NF_SAI	INT, 
								DT_EMI_NF	DATETIME,

								CD_FIL_DEST	INT,
								CD_NF_ENT	INT, 
								DT_ENT_NF	DATETIME,

								DEST_ORIG	INT, 
								CD_CLI		INT, 

								CD_PROD			INT, 
								VLR_CUSTO_MD	MONEY, 
								VLR_IT_RECAL	MONEY,  
								VLR_IT_NF		MONEY,
								CD_NT_MOV		INT,
								QT_IT			MONEY,
								PERC_DESC_IT	MONEY,
								PERC_IPI		MONEY,
								VLR_PROD_FRETE	MONEY,
								VLR_OUTROS		MONEY ) ;

	CREATE NONCLUSTERED INDEX IX_RsProdAjusteMov_DT_EMI_NF ON RsProdAjusteMov  ([DT_EMI_NF])
	INCLUDE ([CD_EMP],[CD_FIL_ORIG],[CD_PROD],[DEST_ORIG],[CD_CLI],[VLR_CUSTO_MD])

/******************************************************************************************************/
/******************************************************************************************************/

	WHILE @DT_REF <=@DT_FIM
	BEGIN
		Print 'Carregando informacoes do dia ' + convert(varchar,@DT_REF,112);

		INSERT INTO RsProdAjusteMov 
		Select 
			EST_NF_SAI.CD_EMP,

			@CD_FILIAL CD_FILIAL,
			EST_NF_SAI.CD_NF,  
			@DT_REF DT_EMI_NF,
		
			E.CD_FILIAL,
			E.CD_NF,  
			E.DT_ENT,
		
			GLB_MOV_OP.DEST_ORIG, 
			EST_NF_SAI.CD_CLI, 
		
			EST_NF_SAI_IT.CD_PROD, 
			EST_NF_SAI_IT.VLR_CUSTO_MD,
			0 AS VLR_PRECO_CUSTO,		 
			EST_NF_SAI_IT.VLR_IT, 
			EST_NF_SAI.CD_NT_MOV,
			EST_NF_SAI_IT.QT_IT,
			EST_NF_SAI_IT.PERC_DESC_IT,
			EST_NF_SAI_IT.PERC_IPI,
			(EST_NF_SAI_IT.VLR_PROD_FRETE/EST_NF_SAI_IT.QT_IT) AS VLR_PROD_FRETE,
			EST_NF_SAI_IT.VLR_OUTROS 
	
		From
			EST_NF_SAI 
			INNER JOIN EST_NF_SAI_IT ON
			EST_NF_SAI.CD_EMP	 = EST_NF_SAI_IT.CD_EMP AND
			EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND
			EST_NF_SAI.CD_NF	 = EST_NF_SAI_IT.CD_NF   AND
			EST_NF_SAI.DT_EMI_NF = EST_NF_SAI_IT.DT_EMI_NF 
	  
			INNER JOIN GLB_MOV_OP ON
			EST_NF_SAI.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP

			INNER JOIN EST_NF_ENT_EST_NF_SAI_TRANSF ON
			EST_NF_SAI.CD_EMP		= EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP AND
			EST_NF_SAI.CD_FILIAL	= EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_ORIG AND
			EST_NF_SAI.CD_NF		= EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_SAI

			INNER JOIN EST_NF_ENT E  ON
			E.CD_EMP		= EST_NF_ENT_EST_NF_SAI_TRANSF.CD_EMP AND
			E.CD_FILIAL	= EST_NF_ENT_EST_NF_SAI_TRANSF.CD_FIL_DEST AND
			E.CD_NF		= EST_NF_ENT_EST_NF_SAI_TRANSF.CD_NF_ENT

		WHERE
			EST_NF_SAI.CD_EMP =1
			AND EST_NF_SAI_IT.CD_FILIAL = @CD_FILIAL
			AND EST_NF_SAI_IT.DT_EMI_NF = @DT_REF
	
		--Atualiza o preco da saida com grossup
		UPDATE A
		SET
			VLR_IT_RECAL=ROUND(dbo.UFD_BUSCA_PRECO_PRODUTO_GROSS_UP(A.CD_EMP,A.CD_FIL_ORIG,A.CD_PROD,0,A.DEST_ORIG, A.CD_CLI,A.VLR_CUSTO_MD),2) 
		FROM 
			 RsProdAjusteMov  A
		where
			DT_EMI_NF=@DT_REF;
	
		--Deleta produto que o valor nao mudou
		DELETE FROM  RsProdAjusteMov  
			WHERE DT_EMI_NF=@DT_REF
			AND ABS(VLR_IT_RECAL - VLR_IT_NF) <= 0.01;

		SET @DT_REF=DATEADD(DAY,1,@DT_REF);
	END
	
/******************************************************************************************************/ 

	BEGIN TRY
		--Exclui p atualizacao	
		DELETE FROM M
		FROM
			EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO A
			INNER JOIN RsProdAjusteMov M ON 
			A.CD_EMP	= M.CD_EMP AND
			A.CD_FIL_ORIG	= M.CD_FIL_ORIG AND
			A.CD_NF_SAI		= M.CD_NF_SAI AND
			A.CD_FIL_DEST	= M.CD_FIL_DEST  AND
			A.CD_NF_ENT		= M.CD_NF_ENT AND
			A.CD_PROD	    = M.CD_PROD; 
			  
		/*****************************************************************/ 
		--Insere controle de altercao...
		/*****************************************************************/ 
		INSERT INTO EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO
			(CD_EMP,CD_FIL_ORIG,CD_NF_SAI,CD_FIL_DEST,CD_NF_ENT,CD_PROD,
				VLR_CUSTO_ACERTO,DT_EMI_NF,DT_ENT_NF,TP_AJUSTE,CD_USU,DT_CAD)
		Select  
			prod.CD_EMP,
			prod.CD_FIL_ORIG,
			prod.CD_NF_SAI,
			prod.CD_FIL_DEST, 
			prod.CD_NF_ENT,
			prod.CD_PROD, 
			A.VLR_CUSTO VLR_CUSTO_ACERTO, 
			prod.DT_EMI_NF,
			prod.DT_ENT_NF,
			2 TP_AJUSTE,
			1 CD_USU, 
			getdate() DT_CAD 
		From
			RsProdAjusteMov  prod
			OUTER APPLY  
			UFD_EST_PROD_TRIB(prod.CD_EMP,
								prod.CD_FIL_ORIG,
								prod.CD_NT_MOV,
								prod.CD_CLI,
								prod.CD_PROD,0, 0, 0, 
								prod.QT_IT, 
								prod.VLR_IT_RECAL, 
								prod.PERC_DESC_IT, 
								prod.PERC_IPI, 
								prod.VLR_PROD_FRETE, 
								prod.VLR_OUTROS) A;
		/*****************************************************************/ 
		--Acerta o custo nas notas fiscais
		/*****************************************************************/ 

		UPDATE I
		SET
			I.VLR_CUSTO_ACERTO = A.VLR_CUSTO_ACERTO
		FROM
			EST_NF_ENT_IT I
			INNER JOIN  EST_NF_ENT_EST_NF_SAI_TRANSF_ACERTO_CUSTO A ON 
			I.CD_EMP	=A.CD_EMP AND
			I.CD_FILIAL =A.CD_FIL_DEST  AND
			I.CD_NF		=A.CD_NF_ENT AND
			I.CD_PROD	=A.CD_PROD  

			INNER JOIN RsProdAjusteMov  prod ON
			A.CD_EMP		= prod.CD_EMP	AND
			A.CD_FIL_ORIG   = prod.CD_FIL_ORIG  AND
			A.CD_NF_SAI		= prod.CD_NF_SAI AND
			A.CD_FIL_DEST	= prod.CD_FIL_DEST AND
			A.CD_NF_ENT		= prod.CD_NF_ENT AND
			A.CD_PROD		= prod.CD_PROD
		WHERE
			I.VLR_CUSTO_ACERTO <> A.VLR_CUSTO_ACERTO; 

			
		BEGIN TRY 
		DROP TABLE RsProdAjusteMov   
		END TRY BEGIN CATCH END CATCH;

	END TRY
	BEGIN CATCH
		Print 'Erro atualizacao'
	END CATCH